#!/usr/bin/env python3
import numpy as np

#
#
# calcul melange type 2 pour des lois HYPOELAS
#
#

# saisie des colonnes temps, EPS11, EPS22, EPS33, SIG11, SIG22, SIG33
data_maple = np.loadtxt("calcul_princ.maple", usecols=(0,4,5,6,8,9,10))
#ci-dessous, on range chaque grandeur dans une variable (et ajout de l instant 0)
TEMPS = np.concatenate((np.array([0.]), data_maple[:,0]))
# NB : conversion des def almansi en def log
EPS11 = np.concatenate((np.array([0.]), np.log(1./np.sqrt(1. - 2.*data_maple[:,1]))))
EPS22 = np.concatenate((np.array([0.]), np.log(1./np.sqrt(1. - 2.*data_maple[:,2]))))
EPS33 = np.concatenate((np.array([0.]), np.log(1./np.sqrt(1. - 2.*data_maple[:,3]))))
SIG11_HZ = np.concatenate((np.array([0.]), data_maple[:,4]))
SIG22_HZ = np.concatenate((np.array([0.]), data_maple[:,5]))
SIG33_HZ = np.concatenate((np.array([0.]), data_maple[:,6]))
data_maple = None

#def get_indice_by_temps(temps_cible):
#  for i, temps in enumerate(TEMPS):
#    if(abs(temps-temps_cible) < 1.e-6): return i 
#  raise Exception(f'temps {temps_cible} introuvable...\nListe des temps dispo : {TEMPS}')


#calcul contrainte 11 a t (i.e a l indice i des tableaux)
def HYPO_SIG11_t(indice_cible, E, NU):
  K = E/(3.*(1.-2.*NU))
  G = E/(2.*(1.+NU))
  SIG11 = 0.
  for i in range(1, indice_cible+1):
    delta_EPS11 = EPS11[i] - EPS11[i-1]
    delta_EPS22 = EPS22[i] - EPS22[i-1]
    delta_EPS33 = EPS33[i] - EPS33[i-1]
    trace_delta_EPS = delta_EPS11 + delta_EPS22 + delta_EPS33
    dev_delta_EPS_I = delta_EPS11 - trace_delta_EPS/3.
    SIG11 += 3.*K*trace_delta_EPS/3. + 2.*G*dev_delta_EPS_I
  return SIG11

#calcul increment de contrainte 11 entre t et t+dt (i.e entre indices i et i+1)
def HYPO_delta_SIG11_t_tdt(indice_cible, E, NU):
  K = E/(3.*(1.-2.*NU))
  G = E/(2.*(1.+NU))
  delta_EPS11 = EPS11[indice_cible+1] - EPS11[indice_cible]
  delta_EPS22 = EPS22[indice_cible+1] - EPS22[indice_cible]
  delta_EPS33 = EPS33[indice_cible+1] - EPS33[indice_cible]
  trace_delta_EPS = delta_EPS11 + delta_EPS22 + delta_EPS33
  dev_delta_EPS_I = delta_EPS11 - trace_delta_EPS/3.
  return 3.*K*trace_delta_EPS/3. + 2.*G*dev_delta_EPS_I

#fonction de melange (a actualiser selon fonction nD "fct_melange" du .info)
def fct_melange(temps_courant):
  #if(temps <= 0.5): return 1.
  #return 0.
  return 1. - 0.6*temps_courant

print("#[1]temps  [2]SIG11 hz++  [3]SIG11 python v1  [4]SIG11 python v2")
SIG11_t = 0.
SIG11_loi_1_propor_tdt = 0.
SIG11_loi_2_propor_tdt = 0.
for ind in range(len(TEMPS)-1):

  #loi 1 E=100, NU=0.3
  #- a t
  SIG11_loi_1_t = HYPO_SIG11_t(ind, 100., 0.3)
  #- increment entre t et t+dt
  delta_SIG11_loi_1_t_tdt = HYPO_delta_SIG11_t_tdt(ind, 100., 0.3)

  #loi 2 E=200, NU=0.45
  #- a t
  SIG11_loi_2_t = HYPO_SIG11_t(ind, 200., 0.45)
  #- increment entre t et t+dt
  delta_SIG11_loi_2_t_tdt = HYPO_delta_SIG11_t_tdt(ind, 200., 0.45)

  #contrainte loi 1 et loi 2 a t+dt
  SIG11_loi_1_tdt = SIG11_loi_1_t + delta_SIG11_loi_1_t_tdt
  SIG11_loi_2_tdt = SIG11_loi_2_t + delta_SIG11_loi_2_t_tdt

  #temps t+dt
  temps = TEMPS[ind+1]

  #ne pas utiliser (cas d un type_melange= 1) => SIG11_melange_tdt = fct_melange(temps)*SIG11_loi_1_tdt + (1. - fct_melange(temps))*SIG11_loi_2_tdt

  #calcul python v1 : melange selon formule doc hz++
  # sigma_final_t+dt = sigma_loi_1_t + sigma_loi_2_t + delta_sigma_final
  #   avec delta_sigma_final = alpha * delta_sigma_loi_1  +  (1-alpha) * delta_sigma_loi_2
  SIG11_melange_tdt = SIG11_loi_1_t + SIG11_loi_2_t + fct_melange(temps)*delta_SIG11_loi_1_t_tdt + (1. - fct_melange(temps))*delta_SIG11_loi_2_t_tdt

  #calcul python v2 : accumulation de contrainte proportionnalisee par loi
  SIG11_loi_1_propor_tdt += fct_melange(temps)*delta_SIG11_loi_1_t_tdt
  SIG11_loi_2_propor_tdt += (1.-fct_melange(temps))*delta_SIG11_loi_2_t_tdt
  SIG11_melange_propor_tdt = SIG11_loi_1_propor_tdt + SIG11_loi_2_propor_tdt

  print(temps, SIG11_HZ[ind+1], SIG11_melange_tdt, SIG11_melange_propor_tdt)
