#!/usr/bin/env perl
use strict;
use warnings;



#fichier .info
my $finfo = "test_RESTART_3D.info";
#executable Herezh
my $exe_HZ = "HZppfast_Vn-1";


#
#
# ce script cree les fichiers calcul_1.log, calcul_1.maple, calcul_2.log, calcul_2.maple
# relatifs a la redirection et aux sorties maple pour un premier calcul jusqu a t=1 et un second 
# calcul avec RESTART jusqu a t=2
#
# le script appelle hz_colMaple.pl pour visualiser dans le terminal le deplacement X1 du noeud 2
# pour ces 2 calculs
#
# => normalement, le deplacement du noeud 2 devrait etre le meme aux temps 1 et 2
#



(my $fmaple = $finfo) =~ s/.info$/_princ.maple/;


#premier calcul (TEMPSFIN 1)
config_info_pour_step_1($finfo);
system("$exe_HZ -f $finfo | tee calcul_1.log");
system("mv -f $fmaple calcul_1.maple");

#deuxieme calcul (TEMPSFIN 2 + RESTART 1)
config_info_pour_step_2($finfo);
system("$exe_HZ -f $finfo | tee calcul_2.log");
system("mv -f $fmaple calcul_2.maple");


#visu deplacement X1 noeud 2
print "\n";
print "\n";
print "----------------------------------------------\n";
print "Deplacement X1 du noeud 2 pour les 2 calculs :\n";
print "----------------------------------------------\n";
system("hz_colMaple.pl calcul_1.maple 1 8 | grep -v \'\#\'");
system("hz_colMaple.pl calcul_2.maple 1 8 | grep -v \'\#\'");
print "\n";

#remise a l etat d origine du .info
config_info_pour_step_1($finfo);



sub config_info_pour_step_1 {
  my $finfo = shift;

  my $fin_modif_info = 0;

  open(my $Hlocal1, "<$finfo");
  open(my $Hlocal2, ">$finfo.tmp");
  while(<$Hlocal1>) {

    if($fin_modif_info) {
      #surtout ne rien faire
    }
    elsif(/^\s*_fin_point_info_\s*$/ or /^\s*_suite_point_info_\s*$/) {
      $fin_modif_info = 1;
    }
    if(/^\s*TEMPSFIN /) {
      $_ = "TEMPSFIN 1.\n";
    }
    elsif(/^\s*RESTART /) {
      $_ = "#RESTART ---\n";
    }

    print $Hlocal2 $_;
  }
  close($Hlocal1);
  close($Hlocal2);

  system("mv -f $finfo.tmp $finfo");
}

sub config_info_pour_step_2 {
  my $finfo = shift;

  my $fin_modif_info = 0;

  open(my $Hlocal1, "<$finfo");
  open(my $Hlocal2, ">$finfo.tmp");
  while(<$Hlocal1>) {

    if($fin_modif_info) {
      #surtout ne rien faire
    }
    elsif(/^\s*_fin_point_info_\s*$/ or /^\s*_suite_point_info_\s*$/) {
      $fin_modif_info = 1;
    }
    if(/^\s*TEMPSFIN /) {
      $_ = "TEMPSFIN 2.\n";
    }
    elsif(/^\s*\#*RESTART /) {
      $_ = "RESTART  1\n";
    }

    print $Hlocal2 $_;
  }
  close($Hlocal1);
  close($Hlocal2);

  system("mv -f $finfo.tmp $finfo");
}
