c
c programme permettant de simuler une UMAT Abaqus sur un point materiel
c
c
      INTEGER NDI,NSHR,NTENS,NSTATV,NPROPS
      INTEGER NOEL,NPT,KSLAY,KSPT,KSTEP,KINC

      REAL*8 STRESS(6),STATEV(0),
     1 DDSDDE(6,6),DDSDDT(6),DRPLDE(6),
     2 STRAN(6),DSTRAN(6),TIME(2),PREDEF(1),DPRED(1),
     3 PROPS(0),COORDS(3),DROT(3,3),
     4 DFGRD0(3,3),DFGRD1(3,3)

      REAL*8 SSE, SPD, SCD, RPL
      REAL*8 DRPLDT
      REAL*8 DTIME, TEMP, DTEMP, PNEWDT, CELENT

      CHARACTER*80 MATERL

      INTEGER I,J

c divers initialisations sans consequence
      NSTATV = 0
      NPROPS = 0
      NOEL = 1
      NPT = 1
      KSLAY = 1
      KSPT = 1
      KSTEP = 1
      PREDEF(1) = 0.
      DPRED(1) = 0.
      KINC = 1
      DO I=1,6
        DDSDDT(I) = 0.
        DRPLDE(I) = 0.
        DO J=1,6
          DDSDDE(I,J) = 0.
        ENDDO
      ENDDO


c initialisation dimensions tenseurs
c     -nb direct components
      NDI = 3
c     -nb shear components
      NSHR = 3
c     -dimension tenseurs
      NTENS = NDI + NSHR


c initialisation contrainte, deformation, increment de deformation
      DO I=1,NTENS
        STRESS(I) = 0.
        STRAN(I) = 0.
        DSTRAN(I) = 0.
      ENDDO

c initialisation :
c  - COORDS : coordonnee du point d integration
c  - DFGRD0 : gradient transfo (F) a t
c  - DFGRD1 : gradient transfo (F) a t+dt
c  - DROT   : tenseur rotation corps rigide

c     on remplit les vecteur et matrice avec des 0.
      DO I=1,3
        COORDS(I) = 0.

        DO J=1,3
          DFGRD0(I,J) = 0.
          DFGRD1(I,J) = 0.
          DROT(I,J) = 0.
        ENDDO
      ENDDO

c     on traite maintenant les composantes diagonales
      DO I=1,3
c       gradient transfo a t et t+dt => pas de transfo pour l instant
c        donc F(i,i) = 1, F(i,j) reste a 0
        DFGRD0(I,I) = 1.
        DFGRD1(I,I) = 1.
c       tenseur rotation corps rigide
c         cas irrotationnel => DROT(i,i) = 1, DROIT(i,j) reste a 0
        DROT(I,I) = 1.
      ENDDO


c nom materiau
      MATERL = 'MAT_HS'

c temps du step et temps total en debut d increment
      TIME(1) = 0.
      TIME(2) = 0.
c increment de temps
      DTIME = 1.

c temperature debut increment et increment de temperature
      TEMP =  0.
      DTEMP = 0.

c maintenant on definit un gradient de transfo en fin d increment
c   on choisit arbitrairement :
c             UX = 0.1
c             UY = -0.05
c    et on calcule UZ de maniere a rester dans le cas incompressible(*)
c      (on est dans le cas d un element de matiere unitaire)
c             V(t) = V(t+dt) =>  UZ = 1/[(1+UX)*(1+UY)] - 1
c
c     (*) NB : on choisit un cas incompressible sinon les contraintes
c              pourraient devenir tres grandes etant donnee la grande valeur de K
c
      DFGRD1(1,1) = 1.d0 + 0.1d0
      DFGRD1(2,2) = 1.d0 - 0.05d0
      DFGRD1(3,3) = 1.d0 + 1.d0/(DFGRD1(1,1)*DFGRD1(2,2)) - 1.d0

c  on definit egalement les increments de deformation correspondant a ce gradient
c   de transfo (deformation logarithmique dans un cas irrotationnel)
c       rq : pas vraiment necessaire dans le cas de certaines lois
c            comme Hart-Smith par exemple (aucune influence de DSTRAN dans
c            ces cas)
      DSTRAN(1) = log(DFGRD1(1,1))
      DSTRAN(2) = log(DFGRD1(2,2))
      DSTRAN(3) = log(DFGRD1(3,3))



c appel UMAT (donc a Herezh)
c    rq : c est a priori normal si le processus Herezh n affiche pas de numero
c         d increment dans le terminal. Aucune idee du pourquoi mais ca ne nuit pas
c         aux resultats.
      CALL UMAT(STRESS,STATEV,DDSDDE,SSE,SPD,SCD,
     1 RPL,DDSDDT,DRPLDE,DRPLDT,STRAN,DSTRAN,
     2 TIME,DTIME,TEMP,DTEMP,PREDEF,DPRED,MATERL,NDI,NSHR,NTENS,
     3 NSTATV,PROPS,NPROPS,COORDS,DROT,PNEWDT,CELENT,
     4 DFGRD0,DFGRD1,NOEL,NPT,KSLAY,KSPT,KSTEP,KINC)


c resultat : affichage contraintes
      WRITE(*,*) 'Resultat UMAT :'
      WRITE(*,*) '  SIG11 = ', STRESS(1)
      WRITE(*,*) '  SIG22 = ', STRESS(2)
      WRITE(*,*) '  SIG33 = ', STRESS(3)

      RETURN
      END





      SUBROUTINE UMAT(STRESS,STATEV,DDSDDE,SSE,SPD,SCD,
     1 RPL,DDSDDT,DRPLDE,DRPLDT,STRAN,DSTRAN,
     2 TIME,DTIME,TEMP,DTEMP,PREDEF,DPRED,MATERL,NDI,NSHR,NTENS,
     3 NSTATV,PROPS,NPROPS,COORDS,DROT,PNEWDT,CELENT,
     4 DFGRD0,DFGRD1,NOEL,NPT,KSLAY,KSPT,KSTEP,KINC)


c      INCLUDE 'ABA_PARAM.INC'

      REAL*8 STRESS(NTENS),STATEV(NSTATV),
     1 DDSDDE(NTENS,NTENS),DDSDDT(NTENS),DRPLDE(NTENS),
     2 STRAN(NTENS),DSTRAN(NTENS),TIME(2),PREDEF(1),DPRED(1),
     3 PROPS(NPROPS),COORDS(3),DROT(3,3),
     4 DFGRD0(3,3),DFGRD1(3,3)

      REAL*8 SSE, SPD, SCD, RPL
      REAL*8 DRPLDT
      REAL*8 DTIME, TEMP, DTEMP, PNEWDT, CELENT

      INTEGER NDI,NSHR,NTENS,NSTATV,NPROPS
      INTEGER NOEL,NPT,KSLAY,KSPT,KSTEP,KINC
      

      PARAMETER (ONE=1.0D0,TWO=2.0D0,THREE=3.0D0,SIX=6.0D0)
      DATA NEWTON,TOLER/10,1.D-6/

c     Appel fonction C fonction du nom du materiau
      CHARACTER(LEN=80) MATERL

c---------------------------------------------
c     declaration appelc pour chaque materiau
c---------------------------------------------
      CHARACTER*80 NOM_MAT_TMP
c     appelc materiau : HVH
      EXTERNAL appelc_1


      IF (NDI.NE.3) THEN
        WRITE(*,1)
 1      FORMAT(//,30X,'***ERROR - THIS UMAT MAY ONLY BE USED FOR ',
     1       'ELEMENTS WITH THREE DIRECT STRESS COMPONENTS')

        RETURN
      ENDIF 

c-------------------------------------------------------
c     selection appelc_i en fonction du nom du materiau
c             (rappel : Abaqus fournit le nom en majuscules)
c-------------------------------------------------------
      NB_CHAR = INDEX(MATERL,' ')-1
      NOM_MAT_TMP = MATERL(1:NB_CHAR)

c     materiau : HVH ==> appelc_1
      IF(NOM_MAT_TMP.EQ.'MAT_HS') THEN

      call appelc_1(
     1  %ref(STRESS),
     2  %ref(DDSDDE),
     3  %ref(SSE),
     4  %ref(SPD),
     5  %ref(SCD),
     6  %ref(RPL),
     7  %ref(DDSDDT),
     8  %ref(DRPLDE),
     9  %ref(DRPLDT),
     1  %ref(STRAN),
     2  %ref(DSTRAN),
     3  %ref(TIME),
     4  %ref(DTIME),
     5  %ref(TEMP),
     6  %ref(DTEMP),
     7  %ref(MATERL // char(0)),
     8  %ref(NDI),
     9  %ref(NSHR),
     1  %ref(NTENS),
     2  %ref(NSTATV),
     3  %ref(PROPS),
     4  %ref(NPROPS),
     5  %ref(COORDS),
     6  %ref(DROT),
     7  %ref(PNEWDT),
     8  %ref(CELENT),
     9  %ref(DFGRD0),
     1  %ref(DFGRD1),
     2  %ref(NOEL),
     3  %ref(NPT),
     4  %ref(KSLAY),
     5  %ref(KSPT),
     6  %ref(KSTEP),
     7  %ref(KINC))

c     ecriture message erreur en cas de materiau non reconnu
      ELSE
        WRITE(*,*) 'erreur : materiau inconnu => ', MATERL
        RETURN
      ENDIF

      RETURN
      END
