/*
------------------------------------------------------
  fichier c++ necessaire au fichier appelc_1.cc
------------------------------------------------------
*/
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <fcntl.h> /* Pour O_WRONLY, etc */
#include <unistd.h>    /* pour les ordres read write close*/

/* definition d'une union qui lie les reels, les entiers et les caracteres */
union Tab_car_double_int
  { char    tampon[928];
    double  x[116];
    int     n[232];
   }  ;

Tab_car_double_int t_car_x_n_1;

/* --- def des variables globales (a commenter certaines si elles sont declarees autre part)  */
/* nom du tube nomme pour l'envoi des donnees */
char* envoi_1="./MAT_ISOHYPER/Umat_envoi_Hz";
/* nom du tube nomme pour la reception des donnees */
char* reception_1="./MAT_ISOHYPER/Umat_reception_Hz";
/* -- declarations des variables de passages avec un nom assez long pour qu'il n'y ait pas */
/* -- de confusion avec les noms du programme appelant */
              /* --- en sortie uniquement */
double* u_herezh_1_DDSDDT  =  &t_car_x_n_1.x[0]; /* 6 */
double* u_herezh_1_DRPLDE  =  &t_car_x_n_1.x[6]; /* 6 */
double* u_herezh_1_DDSDDE =   &t_car_x_n_1.x[12]; /* 36 */
          /* --- en entree - sortie */
double* u_herezh_1_RPL  =     &t_car_x_n_1.x[48]; /* 1 */
double* u_herezh_1_STRESS =   &t_car_x_n_1.x[49]; /* 6 */
double* u_herezh_1_SSE =      &t_car_x_n_1.x[55]; /* 1 */
double* u_herezh_1_SPD =      &t_car_x_n_1.x[56]; /* 1 */
double* u_herezh_1_SCD =      &t_car_x_n_1.x[57]; /* 1 */
double* u_herezh_1_DRPLDT  =  &t_car_x_n_1.x[58]; /* 1 */
double* u_herezh_1_PNEWDT  =  &t_car_x_n_1.x[59]; /* 1 */
          /* --- en entree seulement */
double* u_herezh_1_STRAN  =   &t_car_x_n_1.x[60]; /* 6 */
double* u_herezh_1_DSTRAN  =  &t_car_x_n_1.x[66]; /* 6 */
double* u_herezh_1_TIME  =    &t_car_x_n_1.x[72]; /* 2 */
double* u_herezh_1_DTIME =    &t_car_x_n_1.x[74]; /* 1 */
double* u_herezh_1_TEMP  =    &t_car_x_n_1.x[75]; /* 1 */
double* u_herezh_1_DTEMP  =   &t_car_x_n_1.x[76]; /* 1 */
double* u_herezh_1_COORDS  =  &t_car_x_n_1.x[77]; /* 3 */
double* u_herezh_1_DROT  =    &t_car_x_n_1.x[80]; /* 9 */
double* u_herezh_1_CELENT  =  &t_car_x_n_1.x[89]; /* 1 */
double* u_herezh_1_DFGRD0  =  &t_car_x_n_1.x[90]; /* 9 */
double* u_herezh_1_DFGRD1  =  &t_car_x_n_1.x[99]; /* 9 */

int*    u_herezh_1_NDI  =     &t_car_x_n_1.n[216]; /* 1 */
int*    u_herezh_1_NSHR  =    &t_car_x_n_1.n[217]; /* 1 */
int*    u_herezh_1_NTENS =    &t_car_x_n_1.n[218]; /* 1 */
int*    u_herezh_1_NSTATV  =  &t_car_x_n_1.n[219]; /* 1 */
int*    u_herezh_1_NOEL  =    &t_car_x_n_1.n[220]; /* 1 */
int*    u_herezh_1_NPT =      &t_car_x_n_1.n[221]; /* 1 */
int*    u_herezh_1_LAYER =    &t_car_x_n_1.n[222]; /* 1 */
int*    u_herezh_1_KSPT =     &t_car_x_n_1.n[223]; /* 1 */
int*    u_herezh_1_KSTEP =    &t_car_x_n_1.n[224]; /* 1 */
int*    u_herezh_1_KINC =     &t_car_x_n_1.n[225]; /* 1 */

char*   u_herezh_1_CMNAME  =  &t_car_x_n_1.tampon[904]; /* 24 */


/* --------------------- rappel des parametres de passage de la routine fortran ------------- */

/*          SUBROUTINE UMAT(STRESS,STATEV,DDSDDE,SSE,SPD,SCD,
     1 RPL,DDSDDT,DRPLDE,DRPLDT,STRAN,DSTRAN,
     2 TIME,DTIME,TEMP,DTEMP,PREDEF,DPRED,MATERL,NDI,NSHR,NTENS,
     3 NSTATV,PROPS,NPROPS,COORDS,DROT,PNEWDT,CELENT,
     4 DFGRD0,DFGRD1,NOEL,NPT,KSLAY,KSPT,KSTEP,KINC)
C
      INCLUDE 'ABA_PARAM.INC'
C
      CHARACTER*80 MATERL
      DIMENSION STRESS(NTENS),STATEV(NSTATV),
     1 DDSDDE(NTENS,NTENS),DDSDDT(NTENS),DRPLDE(NTENS),
     2 STRAN(NTENS),DSTRAN(NTENS),TIME(2),PREDEF(1),DPRED(1),
     3 PROPS(NPROPS),COORDS(3),DROT(3,3),
     4 DFGRD0(3,3),DFGRD1(3,3)
C
      DIMENSION EELAS(6),EPLAS(6),FLOW(6)
      PARAMETER (ONE=1.0D0,TWO=2.0D0,THREE=3.0D0,SIX=6.0D0)
      DATA NEWTON,TOLER/10,1.D-6/
*/

/* --------------------- fin rappel des parametres de passage de la routine fortran ------------- */

/* procedure de lecture de recuperation sur le pipe des infos calculees */
void LectureDonneesUmat_1(double* STRESS,double*  DDSDDE
                       ,double* SSE,double* SPD,double* SCD
                       ,const int* NDI,const int* NSHR,const int* NTENS
                       ,double* PNEWDT
                       ,double* RPL,double* DDSDDT,double* DRPLDE,double* DRPLDT)

   {

     /*   Creation d'un processus de reception des donnees */
     int tub;
     /* ouverture du tube nomme en lecture  */
     tub = open(envoi_1,O_RDONLY);
     /* lecture dans le tampon  */
/*      printf("\n ouverture du tampon en lecture %s\n",envoi_1); */
     read (tub,t_car_x_n_1.tampon,480);
     close (tub); /* fermeture du tampon */
     /* transformation de l'information */
     /* Test sur le nombre de composantes directes et cisaillement */
     if ((*NDI == 3) && (*NSHR == 3))
       {/* cas classique 3D */
        int ij;
        for (ij=0;ij<6;ij++)
          {STRESS[ij] = u_herezh_1_STRESS[ij];
           DDSDDT[ij] = u_herezh_1_DDSDDT[ij];
           DRPLDE[ij] = u_herezh_1_DRPLDE[ij];
           int kl;
           for (kl=0;kl<6;kl++)
             {int r=ij*6+kl;
              DDSDDE[r] = u_herezh_1_DDSDDE[r];
             };
           };
       }
     else if ((*NDI == 3) && (*NSHR == 1))
       {/* cas d'elements axisymetrique 3D */
        int ij;
        for (ij=0;ij<4;ij++)
          {STRESS[ij] = u_herezh_1_STRESS[ij];
           DDSDDT[ij] = u_herezh_1_DDSDDT[ij];
           DRPLDE[ij] = u_herezh_1_DRPLDE[ij];
           int kl;
           for (kl=0;kl<4;kl++)
             {int r=ij*4+kl;
              DDSDDE[r] = u_herezh_1_DDSDDE[r];
             };
           };
       };
     *SSE = *u_herezh_1_SSE; *SPD = *u_herezh_1_SPD; *SCD = *u_herezh_1_SCD;
     *PNEWDT = *u_herezh_1_PNEWDT;
     *RPL =  *u_herezh_1_RPL;
     *DRPLDT = *u_herezh_1_DRPLDT;
   };

  union Tab_car_et_double
  {  char tampon[21];
     double truc[2];
   } ;

/* procedure d'ecriture sur le pipe des infos passees par le programme principal */
void EcritureDonneesUmat_1(double* STRESS
                        ,double* SSE,double* SPD,double* SCD
                        ,const double* STRAN,const double* DSTRAN
                        ,const double* TIME,const double* DTIME,const double* TEMP,const double* DTEMP
                        ,const char* CMNAME
                        ,const int* NDI,const int* NSHR,const int* NTENS
                        ,const int* NSTATV
                        ,const double* COORDS,const double* DROT
                        ,double* PNEWDT,const double* CELENT
                        ,const double* DFGRD0,const double* DFGRD1
                        ,const int* NOEL,const int* NPT,const int* LAYER
                        ,const int* KSPT,const int* KSTEP,const int* KINC)
{

/* Test sur le nombre de composantes directes et cisaillement */
  if ((*NDI == 3) && (*NSHR == 3))
   { /* cas classique 3D */
     int ij;
     for (ij=0;ij<6;ij++)
       {u_herezh_1_STRESS[ij] = STRESS[ij];
        u_herezh_1_STRAN[ij] = STRAN[ij];
        u_herezh_1_DSTRAN[ij] = DSTRAN[ij];
       }
   }
   else if ((*NDI == 3) && (*NSHR == 1))
    { /* cas axisymetrique 3D */
      int ij;
      for (ij=0;ij<4;ij++)
      {u_herezh_1_STRESS[ij] = STRESS[ij];
       u_herezh_1_STRAN[ij] = STRAN[ij];
       u_herezh_1_DSTRAN[ij] = DSTRAN[ij];
      };
    };
   *u_herezh_1_SSE = *SSE; *u_herezh_1_SPD = *SPD; *u_herezh_1_SCD = *SCD;
   *u_herezh_1_PNEWDT=  *PNEWDT;
   u_herezh_1_TIME[0]= TIME[0]; u_herezh_1_TIME[1]= TIME[1];
   *u_herezh_1_DTIME = *DTIME;
   *u_herezh_1_TEMP =  *TEMP;
   *u_herezh_1_DTEMP = *DTEMP;
   *u_herezh_1_NDI =  *NDI;
   *u_herezh_1_NSHR = *NSHR;
   *u_herezh_1_NTENS = *NTENS;
   *u_herezh_1_NSTATV = *NSTATV;
   int i;
   for (i=0;i<3;i++)
      {u_herezh_1_COORDS[i]= COORDS[i];
     int j;
       for (j=0;j<3;j++)
         {int r=i*3+j;
          u_herezh_1_DROT[r]= DROT[r]; u_herezh_1_DFGRD0[r]=DFGRD0[r]; u_herezh_1_DFGRD1[r]=DFGRD1[r];
         }
      };
   *u_herezh_1_CELENT = *CELENT;
   *u_herezh_1_NOEL = *NOEL; *u_herezh_1_NPT = *NPT; *u_herezh_1_LAYER = *LAYER; *u_herezh_1_KSPT = *KSPT;
   *u_herezh_1_KSTEP = *KSTEP; *u_herezh_1_KINC = *KINC;
   for (i=0;i<19;i++)
   {if (CMNAME[i] != ' ')
      {u_herezh_1_CMNAME[i] = CMNAME[i];}
    else
      {u_herezh_1_CMNAME[i] = '\0';};
   };


/*   Creation d'un processus de pour l'ecriture des donnees */
/* ouverture du tube nomme en ecriture */
/*   printf("\n on ouvre le tube pour l'ecriture: sp essai"); */
/*   int tub = open(envoi_1,O_WRONLY); */
  int tub = open(reception_1,O_WRONLY);
  /* ecriture dans le tampon  */
  /* en fait l'objectif est d'ecrire que les variables d'entrees ou  */
  /* d'entree sortie      */
  char* tampon_envoi =  &(t_car_x_n_1.tampon[384]);
  write (tub,tampon_envoi,544); /*sizeof(tampon));  */
  close (tub); /* fermeture du tampon */
/*   printf("\n fermeture du tampon: sp essai"); */
  return;
};
