#!/usr/bin/env perl
use strict;
use warnings;
use English;
use File::Basename;
use Cwd qw(cwd abs_path);
my $NOM_PROG = basename $PROGRAM_NAME;
my $ABSPATH_PROG = abs_path($PROGRAM_NAME);
#pattern d un reel pour les regex (desormais redondant avec $RE{num}{real} de Regexp::Common)
my $format_reel = '[+-]?[\.]?\d+[\.]?\d*(?:[eE][+-]?\d*)?';

#Autoflush
$| = 1;



my $eps11 = 0.05;#shift(@ARGV);
my $eps22 = -0.02;#shift(@ARGV);
my $epaisseur_finale = 5.993892206084e-02;#shift(@ARGV);

my $epaisseur_initiale = 0.06;

my $E1 = 200.;
my $E2 = 100.;
my $E3 = 200.;
my $nu12 = 0.45;
my $nu13 = 0.45;
my $nu23 = 0.45;
my $G12 = 54.89;

my $nu21 = $E2*$nu12/$E1;
my $nu31 = $E3*$nu13/$E1;
my $nu32 = $E3*$nu23/$E2;

print "----------------------------\n";
print "calcul contraintes :\n";
print "----------------------------\n";
print "calcul analytique :\n";
my $sig11 = ($E1/(1. - $nu12*$nu21))*($eps11 + $nu21*$eps22);
my $sig22 = ($E1/(1. - $nu12*$nu21))*($nu21*$eps11 + $nu21/$nu12*$eps22);
print "  sig11 = $sig11\n";
print "  sig22 = $sig22\n";

print "doc herezh++ :\n";
$sig11 = ($E1/(1. - $nu12**2))*(      $eps11 + $nu12*$eps22);
$sig22 = ($E1/(1. - $nu12**2))*($nu12*$eps11 +       $eps22);
print "  sig11 = $sig11\n";
print "  sig22 = $sig22\n";


print "\n";
print "----------------------------\n";
print "calcul deformation 33 et epaisseur :\n";
print "----------------------------\n";
print "calcul analytique :\n";
my $eps33 = (-1./(1. - $nu12*$nu21))*($eps11*($nu13 + $nu23*$nu12) + $eps22*($nu23 + $nu13*$nu21));
print "  eps33 = $eps33\n";
print "    ==> epaisseur finale = ", convert_eps2epaisseur($eps33,$epaisseur_initiale), "\n";

print "doc Herezh :\n";
$eps33 = (-$E1/(1. - $nu12**2))*($eps11*($nu12*$nu32 + $nu31) + $eps22*($nu32 + $nu31*$nu12));
print "  eps33 = $eps33\n";
print "    ==> epaisseur finale = ", convert_eps2epaisseur($eps33,$epaisseur_initiale), "\n";

print "calcul Herezh ortho 2D (epaisseur finale : $epaisseur_finale) :\n";
$eps33 = 0.5*(1 - ($epaisseur_finale/$epaisseur_initiale)**-2);
print "  eps33 = $eps33\n";




sub convert_eps2epaisseur {
  my $eps33 = shift;
  my $ep0 = shift;

  return $ep0/sqrt(1.-2.*$eps33);
}
