#!/usr/bin/env perl
use strict;
use warnings;
use English;
use File::Basename;
use Cwd qw(cwd abs_path);
my $NOM_PROG = basename $PROGRAM_NAME;
my $ABSPATH_PROG = abs_path($PROGRAM_NAME);
#pattern d un reel pour les regex (desormais redondant avec $RE{num}{real} de Regexp::Common)
my $format_reel = '[+-]?[\.]?\d+[\.]?\d*(?:[eE][+-]?\d*)?';

#Autoflush
$| = 1;




my $fmaple = 'test_princ.maple';
my $nb_noeuds_set_cdg = shift(@ARGV);

open(FIC, "<$fmaple");
while(<FIC>) {
  next if(not /^\s*\d/);
  my @var = split;

  my $X1_noeud_biel_2 = $var[4];
  my $X2_noeud_biel_2 = $var[5];
  my $X3_noeud_biel_2 = $var[6];
  my @Ubiel = ($X1_noeud_biel_2-150, $X2_noeud_biel_2-100, $X3_noeud_biel_2);

  my @X1_set_cdg;
  my @X2_set_cdg;
  my @X3_set_cdg;

  for(my $i=1; $i<=$nb_noeuds_set_cdg; $i++) {
    push(@X1_set_cdg, $var[4+$i*6]);
    push(@X2_set_cdg, $var[5+$i*6]);
    push(@X3_set_cdg, $var[6+$i*6]);
  }

  my @cdg = (0,0,0);
  for(my $i=0; $i<$nb_noeuds_set_cdg; $i++) {
    $cdg[0] += $X1_set_cdg[$i];
    $cdg[1] += $X2_set_cdg[$i];
    $cdg[2] += $X3_set_cdg[$i];
  }
  $cdg[0] /= $nb_noeuds_set_cdg;
  $cdg[1] /= $nb_noeuds_set_cdg;
  $cdg[2] /= $nb_noeuds_set_cdg;

  print "temps=$var[0] :\n";
  print "  ==> deplacement N_biel_2 => (@Ubiel)\n";
  print "  ==> position cdg =========> (@cdg)\n";
#  print "       X1 : @X1_set_cdg\n";
#  print "       X2 : @X2_set_cdg\n";
#  print "       X3 : @X3_set_cdg\n";
}
close(FIC);
