#!/usr/bin/env perl
use strict;
use warnings;
use English;
use File::Basename;
use Cwd qw(cwd abs_path);
my $NOM_PROG = basename $PROGRAM_NAME;
my $ABSPATH_PROG = abs_path($PROGRAM_NAME);
#pattern d un reel pour les regex (desormais redondant avec $RE{num}{real} de Regexp::Common)
my $format_reel = '[+-]?[\.]?\d+[\.]?\d*(?:[eE][+-]?\d*)?';

#Autoflush
$| = 1;


my $nb_var = shift(@ARGV);



open(FIC, ">cdg_fps.lis");
print FIC "N_set_cdg 1\n";
for(my $i=2; $i<=$nb_var; $i++) {
  print FIC "          $i\n";
}
close(FIC);


open(FIC, ">cdg_fps.var_util");
for(my $i=1; $i<=$nb_var; $i++) {
  print FIC "  Ddl_noeud_ V__X1_$i num_NE_ $i ddl_ X1 temps_ TEMPS_tdt\n";
  print FIC "  Ddl_noeud_ V__X2_$i num_NE_ $i ddl_ X2 temps_ TEMPS_tdt\n";
  print FIC "  Ddl_noeud_ V__X3_$i num_NE_ $i ddl_ X3 temps_ TEMPS_tdt\n";
}
close(FIC);


open(FIC, ">cdg_fps.fct_nD");
print FIC "\nf_cdg_X1_1 FONCTION_EXPRESSION_LITTERALE_nD\n";
print FIC "  deb_list_var_ V__X1_1 \\\n";
for(my $i=2; $i<=$nb_var; $i++) {
  print FIC "                V__X1_$i \\\n";
}
print FIC "  fin_list_var_\n";
print FIC "  fct= (V__X1_1 \\\n";
for(my $i=2; $i<=$nb_var; $i++) {
  print FIC "      + V__X1_$i \\\n";
}
print FIC "      )/$nb_var\n";
print FIC "  fin_parametres_fonction_expression_litterale_\n";

print FIC "\nf_cdg_X2_1 FONCTION_EXPRESSION_LITTERALE_nD\n";
print FIC "  deb_list_var_ V__X2_1 \\\n";
for(my $i=2; $i<=$nb_var; $i++) {
  print FIC "                V__X2_$i \\\n";
}
print FIC "  fin_list_var_\n";
print FIC "  fct= (V__X2_1 \\\n";
for(my $i=2; $i<=$nb_var; $i++) {
  print FIC "      + V__X2_$i \\\n";
}
print FIC "      )/$nb_var\n";
print FIC "  fin_parametres_fonction_expression_litterale_\n";

print FIC "\nf_cdg_X3_1 FONCTION_EXPRESSION_LITTERALE_nD\n";
print FIC "  deb_list_var_ V__X3_1 \\\n";
for(my $i=2; $i<=$nb_var; $i++) {
  print FIC "                V__X3_$i \\\n";
}
print FIC "  fin_list_var_\n";
print FIC "  fct= (V__X3_1 \\\n";
for(my $i=2; $i<=$nb_var; $i++) {
  print FIC "      + V__X3_$i \\\n";
}
print FIC "      )/$nb_var\n";
print FIC "  fin_parametres_fonction_expression_litterale_\n";
close(FIC);
