cl_1 = 1e+22;

//paramètre pour régler le nombre de noeuds

nblarg = 8;		//pour le quart de cercle
nbhaut = 4;		//dans la longueur côté encastrer

//paramètre pour régler les dimensions

l1 = 10; // demie portée de la matrice
jeu = 0.5; // demi jeu entre matrice et poinçon
diametre = 50; // diametre total
epaisseur = 12; // epaisseur de l'éprouvette

// la portée du poinçon se détermine autotmatiquement des autres paramètres

//on créé nos lignes et surfaces

p1 = newp; Point(p1) = {0, 0, 0, cl_1};
lineY1[] = Extrude {(diametre-2*(l1+jeu))/2, 0, 0} {  Point{p1}; Layers{nbhaut};};
lineY2[] = Extrude {jeu/2, 0, 0} {  Point{lineY1[0]}; Layers{nblarg};};
lineY3[] = Extrude {jeu/2, 0, 0} {  Point{lineY2[0]}; Layers{nblarg};};
lineY4[] = Extrude {l1, 0, 0} {  Point{lineY3[0]}; Layers{nbhaut};};

Extrude {0, epaisseur, 0} {Line{lineY1[1],lineY2[1],lineY3[1],lineY4[1]}; Layers{nbhaut};}

//Transfinite permettant de passer en quadrangle ( uniquement avec maillage paramétré )


Transfinite Surface {8};
Transfinite Surface {12};
Transfinite Surface {16};
Transfinite Surface {20};
Coherence;
Coherence;

//extrusion pour avoir 1/4 de la géométrie


Extrude {{0, 1, 0}, {0, 0, 0}, Pi/2} {
  Surface{8, 12, 16, 20};Layers{nblarg};Recombine;
}


Physical Volume("tout") = {1, 4, 3, 2};
Physical Surface("bloc") = {94};
Physical Surface("blocx") = {35, 103, 37, 81, 59};
Physical Surface("blocz") = {54, 20, 16, 12, 8};
Physical Surface("cm") = {90};
Physical Surface("poincon") = {28};
Physical Surface("cp") = {35};
Physical Surface("mat") = {98};
Physical Line("cisaillement") = {40};
