#!/bin/sh

fonction ()
{
# purge des fichiers non indispensables
echo " --> Purge des fichiers"
rm -f *.BI *.PI *.msh *.opt *.her *.lis *.log ancienNom *.pos
rm -f *.txt~ *.opt~ *.geo~ *.info~ *.sh~ *.BI~ *.PI~ *.msh~ *.her~ *.lis~ *.log~ *.pos~

# Maillage de la géométrie
echo " --> Création du maillage avec Gmsh"
gmsh -3 -order 1 boisrond.geo > calcul.log	#attention aux options par défaut de gmsh

# Conversion du maillage .msh en .her
echo " --> Conversion du maillage msh en her"
msh2her.pl boisrond.msh <boisrond_rep_msh2her.txt >>calcul.log

# Nettoyage
echo " --> Nettoyage"
HZppfast64 -f boisrond_nettoyage.info <boisrond_nettoyage.txt >> calcul.log

# calcul EF avec Herezh++
echo " --> Calcul EF"
HZppfast64 -f boisrond.info | tee -a calcul.log

# ouverture avec gmsh
gmsh boisrond_Gmsh/boisrond_deplace_Gmsh.pos

}
fonction
