#!/usr/bin/python
#-*- coding: utf-8 -*-
import os
import time
from struct import unpack
from struct import pack
from threading import Thread


def executionHerezh():

    os.system('/home/frank/squashfs-root/AppRun -f modele.info > modele.log')
    print('Fin du calcul Herezh')


def Calcul_pression(variable_out):
    
    return variable_out[-1]
    

def fonction_externe():

    # Nom fonction nD
    nom_fonction_nD = 'fext_press'

    # Valeurs de sortie fonction nD
    valeur = 0.001

    # Description du PipeOUT :
    nb_variable_out = 3  # Nombre de variables dans PipeOUT et PipeIN : 2 entiers -> 2*4 = 8 bytes
    nb_variable_in  = 1  # - variables PipeOUT : réels double -> 2*8 = 16 bytes
    nb_byte_out = 2*4 + nb_variable_out*8  # Nombre total de byte
    print("Nombre d'octets attendu :",nb_byte_out)  


    nomPipeOUT=nom_fonction_nD + '_envoi_Hz.FIFO'
    nomPipeIN=nom_fonction_nD + '_reception_Hz.FIFO'

    # Ouverture des pipes
    PipeOUT = os.open(nomPipeOUT,os.O_RDONLY)
    PipeIN  = os.open(nomPipeIN,os.O_WRONLY)

    compteur_boucle = 0 
    while 1:     
        compteur_boucle += 1 
        
        # Lecture PipeOut
        line = os.read(PipeOUT, nb_byte_out) 
        
        if line==b'':
            break

        time.sleep(0.002)

        # Décodage du PipeOut (i si entier,  d si float double) 
        variable_out = unpack('@ii'+nb_variable_out*'d', line) 
        nbre_arg_out, nbre_arg_in = variable_out[:2]
        
        pression = Calcul_pression(variable_out)
        
        # Encodage du PipeIN et écriture
        line = pack('@ii'+nb_variable_in*'d', nbre_arg_out, nbre_arg_in, pression)        
        os.write(PipeIN, line)

        if compteur_boucle!=0:
            print('Compteur boucle : ',compteur_boucle)
            print('Variables out = ',variable_out[2:])
            
        time.sleep(0.002)
         
 
    os.close(PipeOUT)
    os.close(PipeIN)

    print('Fin calcul fonction externe')


if __name__ == '__main__':

    # Création des threads
    thread1 = Thread(target=executionHerezh)
    thread2 = Thread(target=fonction_externe)

    # Lancement des threads
    thread1.start()
    thread2.start()

    thread1.join()
    thread2.join()
