#!/usr/bin/env perl
use strict;
use warnings;
use English;
use File::Basename;
use File::Glob qw(bsd_glob);#idem glob() mais en gerant les cas de fichiers/repertoires contenant des espaces
use Cwd qw(cwd abs_path);
my $NOM_PROG = basename $PROGRAM_NAME;
my $ABSPATH_PROG = abs_path($PROGRAM_NAME);
#pattern d un reel pour les regex (desormais redondant avec $RE{num}{real} de Regexp::Common)
my $format_reel = '[+-]?[\.]?\d+[\.]?\d*(?:[eE][+-]?\d*)?';

#Autoflush
$| = 1;

my $v0 = 1./8.;
my $col_moins_p = 5;
my $col_v = 12;

my $moins_p_prec = 0.;
my $V_prec = 1.;
open(FIC, "<calcul_princ.maple");
print "#[1]temps  [2]Ks\n";
while(<FIC>) {
  next if(not /^\s*\d/);
  @_ = split;
  my $temps = $_[0];
  my $moins_p = $_[$col_moins_p-1];
  my $V = $_[$col_v-1]/$v0;
  my $Ks = ($moins_p-$moins_p_prec)/($V - $V_prec);

  print "$temps $Ks\n";

  $moins_p_prec = $moins_p;
  $V_prec = $V;
}
close(FIC);
