#!/usr/bin/env perl
use strict;
use warnings;
use English;
use Math::Trig;



my $regul = 1.;



my $ref_tens;
for(my $i=0; $i<=2; $i++) {
  for(my $j=0; $j<=2; $j++) {
  $ref_tens->[$i][$j] = 0.;
}}

my $NU = 0.45;
my $eps = 1.;

#TENSEUR TYPE TRACTION UNIAXIALE
$ref_tens->[0][0] = $eps;
$ref_tens->[1][1] = -$NU*$ref_tens->[0][0];
$ref_tens->[2][2] = -$NU*$ref_tens->[0][0];

#TENSEUR TYPE CISAILLEMENT
#$ref_tens->[0][0] = $eps;
#$ref_tens->[1][1] = -$eps;
#$ref_tens->[2][2] = 0.;

my $trace = trace_o2_d3($ref_tens);

my $ref_dev_tens;
for(my $i=0; $i<=2; $i++) {
  for(my $j=0; $j<=2; $j++) {
  $ref_dev_tens->[$i][$j] = $ref_tens->[$i][$j];
}}
for(my $i=0; $i<=2; $i++) {$ref_dev_tens->[$i][$i] -= $trace/3.;}


($_, my $J2, my $J3) = invariants_o2_d3($ref_dev_tens);

my $Qeps = sqrt(-2.*$J2);
my $cos3phi_Qeps_regul = 3.*sqrt(6.)*$J3/($Qeps+$regul)**3;
print "Qeps +regul => cos3phi    = $cos3phi_Qeps_regul\n";
print "            => angle Lode = ", (acos($cos3phi_Qeps_regul)/3.)*180./pi, "\n";




sub trace_o2_d3 {return($_[0]->[0][0] + $_[0]->[1][1] + $_[0]->[2][2]);}

sub invariants_o2_d3 {
  my $ref_tens = shift;

  my $ref_tens_2 = simple_contract_o2_d3($ref_tens,$ref_tens);
  my $ref_tens_3 = simple_contract_o2_d3($ref_tens_2,$ref_tens);

  my $I1 = trace_o2_d3($ref_tens);
  my $I2 = ($I1**2. - trace_o2_d3($ref_tens_2))/2.;
  my $I3 = (trace_o2_d3($ref_tens_3) - 3.*$I1*trace_o2_d3($ref_tens_2)/2. + ($I1**3)/2.)/3.;
  
  return($I1,$I2,$I3);
}#sub invariants_o2_d3

sub simple_contract_o2_d3 {
 my $ref_tens1 = shift;
 my $ref_tens2 = shift;
 my $ref_tens;

 for(my $i=0; $i<=2; $i++) {
  for(my $j=0; $j<=2; $j++) {
   $ref_tens->[$i][$j] = 0.;
   for(my $k=0; $k<=2; $k++) {
     $ref_tens->[$i][$j] += $ref_tens1->[$i][$k]*$ref_tens2->[$k][$j];
 }}}

 return($ref_tens);
}#sub simple_contract_o2_d3
