#!/usr/bin/python
#-*- coding: utf-8 -*-
import os
import sys
import time
from struct import unpack
from struct import pack
from pathlib import Path
import threading
import numpy as np
import pickle
import time

#---------------------------------------------------------
#     Chemin d'accès Herezh à mettre à jour
#---------------------------------------------------------
path_Herezh = '/home/frank/squashfs-root/AppRun'

# Nom fonction nD
nom_fonction_nD = 'fext_pressCFD'

# Nombre de noeuds du maillage
nombre_elements = 50

# Description du PipeOUT :
nb_variable_out = 3  # Nombre de variables sortie fct externe
nb_variable_in  = 1  # Nombre de variables entrée fct externe (nb_double_ret_)

def executionHerezh():

    # Lancement Herezh
    print('Execution Herezh')
    os.system('time ' + path_Herezh + ' -f modele.info > modele.log')

    # Supression des fichers pipes
    os.system('rm -f *.FIFO')

 
def fonction_externe(nomPipeOUT, nomPipeIN, nb_variable_out, nb_variable_in, pid):

    pid.append(threading.get_native_id())
    print('Démarrage fonction externe (pid ' + str(pid[0])+')')
    
    compteur_elements = 1
    
    while True:     
    
        # Lecture PipeOut
        PipeOUT = os.open(nomPipeOUT,os.O_RDONLY)
        line = os.read(PipeOUT, nb_byte_out)
        os.close(PipeOUT)                
        
        # Décodage du PipeOut (i si entier,  d si float double) 
        variable_out = unpack('@ii'+nb_variable_out*'d', line) 
        
        # Grandeurs transmises par défaut
        nbre_arg_out, nbre_arg_in = variable_out[:2] 
        
        # Grandeurs transmises par la fonction nD
        compteur_increment = int(variable_out[2])
        temps_courant = variable_out[3]            
        stat_vect_position_1 = variable_out[4]            
        # stat_vect_position_2 = variable_out[5]            
        
        # Variable de sortie
        v_sortie = 0
        
        # Encodage du PipeIN et écriture
        line = pack('@ii'+nb_variable_in*'d', nbre_arg_out, nbre_arg_in, v_sortie)        
        PipeIN  = os.open(nomPipeIN,os.O_WRONLY)
        os.write(PipeIN, line)
        os.close(PipeIN)                                   
        
        # Traitement après passage sur tous les éléments
        if compteur_elements == nombre_elements:                                         
            
            print('--Increment {:4d}, Temps {:.4f}, stat_pos_1 {:5.3e}'\
                   .format(compteur_increment, temps_courant,
                            stat_vect_position_1))
                
            compteur_elements = 1
        else:
            compteur_elements += 1


if __name__ == '__main__':

    nomPipeOUT=nom_fonction_nD + '_envoi_Hz.FIFO'
    nomPipeIN=nom_fonction_nD + '_reception_Hz.FIFO'
    
    # Description du PipeOUT :
    nb_byte_out = 2*4 + nb_variable_out*8  # Nombre total de byte

    # initialisation liste contenant le pid du thread2
    pid = []

    # Création des threads
    thread1 = threading.Thread(target=executionHerezh)
    thread2 = threading.Thread(target=fonction_externe,\
                args=(nomPipeOUT, nomPipeIN, nb_variable_out, nb_variable_in, pid))

    # Test existance des pipes 
    if not os.path.exists(nomPipeOUT) or not os.path.exists(nomPipeIN):
        print('Création des pipes')
        os.mkfifo(nomPipeOUT)
        os.mkfifo(nomPipeIN)

    # Exécution des threads
    thread1.start()
    thread2.start()

    # On attend la fin thread1 (Herezh)
    thread1.join()  
 
    # Interruption du thread2 (fonction externe)
    print('Arrêt fonction externe (kill process)') 
    os.system('kill '+ str(pid[0]))
