#!/usr/bin/env perl
use strict;
use warnings;
use English;
use File::Basename;
use Cwd qw(cwd abs_path);
my $NOM_PROG = basename $PROGRAM_NAME;
my $ABSPATH_PROG = abs_path($PROGRAM_NAME);
#pattern d un reel pour les regex (desormais redondant avec $RE{num}{real} de Regexp::Common)
my $format_reel = '[+-]?[\.]?\d+[\.]?\d*(?:[eE][+-]?\d*)?';

#Autoflush
$| = 1;


($#ARGV == 1) or die "\nErreur : 1 arg requis (.her)...\n\n";
my $fher = shift(@ARGV);
my $nom_set = shift(@ARGV);

my ($nom_maillage, $nb_noeuds, $ref_tab_noeuds, $nb_elts, $ref_tab_elts, @ref_listes) = lecture_mail_her($fher);

my @n = @{$ref_listes[0]->{$nom_set}};
my $X_moy = 0;
my $Y_moy = 0;
my $Z_moy = 0;
my $nb = $#n + 1;
foreach my $n (@n) {
  $X_moy += $ref_tab_noeuds->[$n][0];
  $Y_moy += $ref_tab_noeuds->[$n][1];
  $Z_moy += $ref_tab_noeuds->[$n][2];
}
$X_moy /= $nb;
$Y_moy /= $nb;
$Z_moy /= $nb;
print "$X_moy\n";
print "$Y_moy\n";
print "$Z_moy\n";


#sub qui ecrit un fichier .her
# (avec ou sans .lis selon argument $is_lis)
sub ecrire_her {
  my $fher = shift;
  my $nom_maillage = shift;
  my $nb_noeuds = shift;
  my $ref_tab_noeuds = shift;
  my $nb_elts = shift;
  my $ref_tab_elts = shift;
  my $ref_liste_ref = shift;
  my $is_lis = shift;


  $fher .= ".her" if(not $fher =~ /.her$/);

  open(my $Fher, ">$fher");
  if(defined($nom_maillage)) {print $Fher " nom_maillage  $nom_maillage\n\n";}
  print $Fher " noeuds\n";
  print $Fher " $nb_noeuds NOEUDS\n";
  print $Fher "\n";
  for(my $i=1; $i<=$nb_noeuds; $i++) {print $Fher " $i @{$ref_tab_noeuds->[$i]}\n";}

  #ecriture des refs de noeuds si pas de .lis a creer
  if(not $is_lis) {
    print $Fher "\n";
    foreach my $nom_liste (keys %{$ref_liste_ref->[0]}) {
      print $Fher "\n";
      ecrire_liste_N_E($Fher, $nom_liste, @{$ref_liste_ref->[0]{$nom_liste}});
    }
    print $Fher "\n";
  }

  print $Fher "\n";
  print $Fher " elements\n";
  print $Fher " $nb_elts ELEMENTS\n";
  print $Fher "\n";
  for(my $i=1; $i<=$nb_elts; $i++) {print $Fher " $i  $ref_tab_elts->{$i}{'TYPE'}  @{$ref_tab_elts->{$i}{'CONNEX'}}\n";}

  #ecriture des refs d aretes, faces, elements et pt integration si pas de .lis a creer
  if(not $is_lis) {
    print $Fher "\n";
    foreach my $nom_liste (keys %{$ref_liste_ref->[1]}) {
      print $Fher "\n";
      ecrire_liste_A_F($Fher, $nom_liste, @{$ref_liste_ref->[1]{$nom_liste}});
    }
    foreach my $nom_liste (keys %{$ref_liste_ref->[2]}) {
      print $Fher "\n";
      ecrire_liste_A_F($Fher, $nom_liste, @{$ref_liste_ref->[2]{$nom_liste}});
    }
    foreach my $nom_liste (keys %{$ref_liste_ref->[3]}) {
      print $Fher "\n";
      ecrire_liste_N_E($Fher, $nom_liste, @{$ref_liste_ref->[3]{$nom_liste}});
    }
    foreach my $nom_liste (keys %{$ref_liste_ref->[4]}) {
      print $Fher "\n";
      ecrire_liste_A_F($Fher, $nom_liste, @{$ref_liste_ref->[4]{$nom_liste}});
    }
  }
  close($Fher);

  #on s arrete la si il n y a pas de .lis a creer
  return if(not $is_lis);


  my $flis = $fher; $flis =~ s/.her$/.lis/;
  my @is_ref = ();
  push(@is_ref, keys %{$ref_liste_ref->[0]}, keys %{$ref_liste_ref->[1]}, keys %{$ref_liste_ref->[2]}, keys %{$ref_liste_ref->[3]}, keys %{$ref_liste_ref->[4]});
  return if($#is_ref == -1);#on arrete la si il n y a aucune ref (on renvoie 0)

  open(my $Hflis, ">$flis");
  foreach my $nom_liste (keys %{$ref_liste_ref->[0]}) {
    print $Hflis "\n";
    ecrire_liste_N_E($Hflis, $nom_liste, @{$ref_liste_ref->[0]{$nom_liste}});
  }
  foreach my $nom_liste (keys %{$ref_liste_ref->[1]}) {
    print $Hflis "\n";
    ecrire_liste_A_F($Hflis, $nom_liste, @{$ref_liste_ref->[1]{$nom_liste}});
  }
  foreach my $nom_liste (keys %{$ref_liste_ref->[2]}) {
    print $Hflis "\n";
    ecrire_liste_A_F($Hflis, $nom_liste, @{$ref_liste_ref->[2]{$nom_liste}});
  }
  foreach my $nom_liste (keys %{$ref_liste_ref->[3]}) {
    print $Hflis "\n";
    ecrire_liste_N_E($Hflis, $nom_liste, @{$ref_liste_ref->[3]{$nom_liste}});
  }
  foreach my $nom_liste (keys %{$ref_liste_ref->[4]}) {
    print $Hflis "\n";
    ecrire_liste_A_F($Hflis, $nom_liste, @{$ref_liste_ref->[4]{$nom_liste}});
  }
  close($Hflis);
}




#ecrire une liste de noeuds et elements
sub ecrire_liste_N_E {
  my $handle = shift;
  my $nom_liste = shift;
  my @liste_no = @_;

  my $cpt; my $cpt_max = 15; my $nb_blancs;

  $nb_blancs = ""; $nb_blancs .= " " for(1 .. length($nom_liste));
  $_ = shift(@liste_no);
  print $handle " $nom_liste $_";
  $cpt = 1;
  foreach my $no (@liste_no) {
    $cpt++;
    if($cpt == 1) {print $handle " $nb_blancs $no";}
    elsif($cpt == $cpt_max) {print $handle " $no\n"; $cpt = 0;}
    else {print $handle " $no";}
  }
  print $handle "\n" if($cpt != $cpt_max);
}#sub ecrire_liste_noeuds


#ecrire une liste d aretes et faces
sub ecrire_liste_A_F {
  my $handle = shift;
  my $nom_liste = shift;
  my @liste_no = @_;

  my $cpt; my $cpt_max = 30; my $nb_blancs;

  $nb_blancs = ""; $nb_blancs .= " " for(1 .. length($nom_liste));
  $_ = shift(@liste_no);
  print $handle " $nom_liste $_";
  $cpt = 1;
  foreach my $no (@liste_no) {
    $cpt++;
    if($cpt == 1) {print $handle " $nb_blancs $no";}
    elsif($cpt == $cpt_max) {print $handle " $no\n"; $cpt = 0;}
    else {print $handle " $no";}
  }
  print $handle "\n" if($cpt != $cpt_max);
}


#----------------
#sub qui lit un maillage herezh++ pour recuperer les noeuds, les elements et les listes de references
#et les renvoier sous forme de reference (lecture du .her et d un .lis si il existe)
#
# exemple d appel :
#  my ($nom_maillage, $nb_noeuds, $ref_tab_noeuds, $nb_elts, $ref_tab_elements, @ref_listes) = lecture_mail_her("fic_her");
#
#  avec - $nom_maillage     : nom du maillage (si il y en a un. sinon $nom_maillage sera egal a undef
#       - $nb_noeuds        : nombre de noeuds (entier)
#       - $ref_tab_noeuds   : reference vers un tableau de noeuds => $ref_tab_noeuds->[no noeud][0] : coordonnee x
#                                                                    $ref_tab_noeuds->[no noeud][1] : coordonnee y
#                                                                    $ref_tab_noeuds->[no noeud][2] : coordonnee z)
#       - $nb_elts          : nombre d elements (entier)
#       - $ref_tab_elements : reference vers une table de hashage => $ref_tab_elements->{no elt}{'TYPE'}      : type d element
#                                                                    @{$ref_tab_elements->{no elt}{'CONNEX'}} : (liste des noeuds)
#       - @ref_listes       : liste de references vers les tables de hashage contenant les listes de references de noeuds, aretes, faces et elements
#                             => $ref_listes[0] : reference vers la table de hashage des listes de noeuds  => @{$ref_listes[0]->{'nom liste'}} : (liste des noeuds)
#                                $ref_listes[1] : reference vers la table de hashage des listes d aretes   => @{$ref_listes[1]->{'nom liste'}} : (liste des aretes)
#                                $ref_listes[2] : reference vers la table de hashage des listes de faces   => @{$ref_listes[2]->{'nom liste'}} : (liste des faces)
#                                $ref_listes[3] : reference vers la table de hashage des listes d elements => @{$ref_listes[3]->{'nom liste'}} : (liste des elements)
#                                $ref_listes[4] : reference vers la table de hashage des listes de points d integration => @{$ref_listes[4]->{'nom liste'}} : (liste des points d integration)
#                                
sub lecture_mail_her {
  my $fher = shift;

  my $nom_maillage;

  #------------------------
  # lecture du maillage .her
  #------------------------
  #-lecture de noeuds
  my @tab_noeuds; my $nb_noeuds;
  my $no_noeud = 0;
  open(Fher, "<$fher");
  while(<Fher>) {
    if(/^\s*nom_maillage\s+(\S+)/) {$nom_maillage = $1; next;}
    next if(not /(\d+)\s+NOEUDS/);
    $nb_noeuds = $1;
    last;
  }
  while(<Fher>) {
    last if($no_noeud == $nb_noeuds);
    next if(not /^\s*(\d+)\s+(\S+)\s+(\S+)\s+(\S+)\s*$/);
    $no_noeud = $1;
    @{$tab_noeuds[$no_noeud]} = ($2,$3,$4);
  }

  #-lecture des elements
  my %tab_elements; my $nb_elts;
  my $no_elt = 0;
  while(<Fher>) {
    next if(not /(\d+)\s+ELEMENTS/);
    $nb_elts = $1;
    last;
  }
  while(<Fher>) {
    last if($no_elt == $nb_elts);
    next if(not /^\s*\d+\s+\w+\s+\w+/);
    s/^\s+//;s/\s+$//;
    $_ =~ /^(\d+)\s+/;
    $no_elt = $1; s/^(\d+)\s+//;
    $_ =~ /\s+(\d+(?:\s+\d+)*)$/;
    @{$tab_elements{$no_elt}{'CONNEX'}} = split(/\s+/, $1); s/\s+(\d+(?:\s+\d+)*)$//;
    $tab_elements{$no_elt}{'TYPE'} = $_; $tab_elements{$no_elt}{'TYPE'} =~ s/\s+/ /g;
  }
  close(Fher);


  #------------------------
  # lecture des references (dans le .her et dans un eventuel .lis)
  #------------------------
  my $flis = $fher; $flis =~ s/.her$/.lis/;
  my $nom_liste;
  my $is_liste_en_cours;
  my %listes_NOEUDS;
  my %listes_ARETES;
  my %listes_FACES;
  my %listes_ELEMENTS;
  my %listes_PTI;

  #-dans le .her
  open(Fher, "<$fher");
  $is_liste_en_cours = 0;
  while(<Fher>) {
    chomp;
    if(/^\s*(N\S+)/) {
      $nom_liste = $1;
      $is_liste_en_cours = 1;
      s/^\s*N\S+\s+//; s/\s+$//;
      push(@{$listes_NOEUDS{$nom_liste}},split(/\s+/,$_));
    }
    elsif(/^\s*noeuds/i or /^\s*elements/i or /^\s*[AFEG]/) {
      $is_liste_en_cours = 0;
    }
    elsif($is_liste_en_cours and /^\s*\d+(\s+\d+)*\s*$/i) {
      s/^\s+//; s/\s+$//;
      push(@{$listes_NOEUDS{$nom_liste}},split(/\s+/,$_));
    }
  }
  close(Fher);

  open(Fher, "<$fher");
  $is_liste_en_cours = 0;
  while(<Fher>) {
    chomp;
    if(/^\s*(A\S+)/) {
      $nom_liste = $1;
      $is_liste_en_cours = 1;
      s/^\s*A\S+\s+//; s/\s+$//;
      push(@{$listes_ARETES{$nom_liste}},split(/\s+/,$_));
    }
    elsif(/^\s*noeuds/i or /^\s*elements/i or /^\s*[NFEG]/) {
      $is_liste_en_cours = 0;
    }
    elsif($is_liste_en_cours and /^\s*\d+(\s+\d+)*\s*$/i) {
      s/^\s+//; s/\s+$//;
      push(@{$listes_ARETES{$nom_liste}},split(/\s+/,$_));
    }
  }
  close(Fher);

  open(Fher, "<$fher");
  $is_liste_en_cours = 0;
  while(<Fher>) {
    chomp;
    if(/^\s*(F\S+)/) {
      $nom_liste = $1;
      $is_liste_en_cours = 1;
      s/^\s*F\S+\s+//; s/\s+$//;
      push(@{$listes_FACES{$nom_liste}},split(/\s+/,$_));
    }
    elsif(/^\s*noeuds/i or /^\s*elements/i or /^\s*[NAEG]/) {
      $is_liste_en_cours = 0;
    }
    elsif($is_liste_en_cours and /^\s*\d+(\s+\d+)*\s*$/i) {
      s/^\s+//; s/\s+$//;
      push(@{$listes_FACES{$nom_liste}},split(/\s+/,$_));
    }
  }
  close(Fher);

  open(Fher, "<$fher");
  $is_liste_en_cours = 0;
  while(<Fher>) {
    chomp;
    if(/^\s*(E\S+)/) {
      $nom_liste = $1;
      $is_liste_en_cours = 1;
      s/^\s*E\S+\s+//; s/\s+$//;
      push(@{$listes_ELEMENTS{$nom_liste}},split(/\s+/,$_));
    }
    elsif(/^\s*noeuds/i or /^\s*elements/i or /^\s*[NAFG]/) {
      $is_liste_en_cours = 0;
    }
    elsif($is_liste_en_cours and /^\s*\d+(\s+\d+)*\s*$/i) {
      s/^\s+//; s/\s+$//;
      push(@{$listes_ELEMENTS{$nom_liste}},split(/\s+/,$_));
    }
  }
  close(Fher);

  open(Fher, "<$fher");
  $is_liste_en_cours = 0;
  while(<Fher>) {
    chomp;
    if(/^\s*(G\S+)/) {
      $nom_liste = $1;
      $is_liste_en_cours = 1;
      s/^\s*G\S+\s+//; s/\s+$//;
      push(@{$listes_PTI{$nom_liste}},split(/\s+/,$_));
    }
    elsif(/^\s*noeuds/i or /^\s*elements/i or /^\s*[NAFE]/) {
      $is_liste_en_cours = 0;
    }
    elsif($is_liste_en_cours and /^\s*\d+(\s+\d+)*\s*$/i) {
      s/^\s+//; s/\s+$//;
      push(@{$listes_PTI{$nom_liste}},split(/\s+/,$_));
    }
  }
  close(Fher);


  #dans le .lis (si il existe)
  if(-e $flis) {

  open(Flis, "<$flis");
  $is_liste_en_cours = 0;
  while(<Flis>) {
    chomp;
    if(/^\s*(N\S+)/) {
      $nom_liste = $1;
      $is_liste_en_cours = 1;
      s/^\s*N\S+\s+//; s/\s+$//;
      push(@{$listes_NOEUDS{$nom_liste}},split(/\s+/,$_));
    }
    elsif(/^\s*noeuds/i or /^\s*elements/i or /^\s*[AFEG]/) {
      $is_liste_en_cours = 0;
    }
    elsif($is_liste_en_cours and /^\s*\d+(\s+\d+)*\s*$/i) {
      s/^\s+//; s/\s+$//;
      push(@{$listes_NOEUDS{$nom_liste}},split(/\s+/,$_));
    }
  }
  close(Flis);

  open(Flis, "<$flis");
  $is_liste_en_cours = 0;
  while(<Flis>) {
    chomp;
    if(/^\s*(A\S+)/) {
      $nom_liste = $1;
      $is_liste_en_cours = 1;
      s/^\s*A\S+\s+//; s/\s+$//;
      push(@{$listes_ARETES{$nom_liste}},split(/\s+/,$_));
    }
    elsif(/^\s*noeuds/i or /^\s*elements/i or /^\s*[NFEG]/) {
      $is_liste_en_cours = 0;
    }
    elsif($is_liste_en_cours and /^\s*\d+(\s+\d+)*\s*$/i) {
      s/^\s+//; s/\s+$//;
      push(@{$listes_ARETES{$nom_liste}},split(/\s+/,$_));
    }
  }
  close(Flis);

  open(Flis, "<$flis");
  $is_liste_en_cours = 0;
  while(<Flis>) {
    chomp;
    if(/^\s*(F\S+)/) {
      $nom_liste = $1;
      $is_liste_en_cours = 1;
      s/^\s*F\S+\s+//; s/\s+$//;
      push(@{$listes_FACES{$nom_liste}},split(/\s+/,$_));
    }
    elsif(/^\s*noeuds/i or /^\s*elements/i or /^\s*[NAEG]/) {
      $is_liste_en_cours = 0;
    }
    elsif($is_liste_en_cours and /^\s*\d+(\s+\d+)*\s*$/i) {
      s/^\s+//; s/\s+$//;
      push(@{$listes_FACES{$nom_liste}},split(/\s+/,$_));
    }
  }
  close(Flis);

  open(Flis, "<$flis");
  $is_liste_en_cours = 0;
  while(<Flis>) {
    chomp;
    if(/^\s*(E\S+)/) {
      $nom_liste = $1;
      $is_liste_en_cours = 1;
      s/^\s*E\S+\s+//; s/\s+$//;
      push(@{$listes_ELEMENTS{$nom_liste}},split(/\s+/,$_));
    }
    elsif(/^\s*noeuds/i or /^\s*elements/i or /^\s*[NAFG]/) {
      $is_liste_en_cours = 0;
    }
    elsif($is_liste_en_cours and /^\s*\d+(\s+\d+)*\s*$/i) {
      s/^\s+//; s/\s+$//;
      push(@{$listes_ELEMENTS{$nom_liste}},split(/\s+/,$_));
    }
  }
  close(Flis);

  open(Flis, "<$flis");
  $is_liste_en_cours = 0;
  while(<Flis>) {
    chomp;
    if(/^\s*(G\S+)/) {
      $nom_liste = $1;
      $is_liste_en_cours = 1;
      s/^\s*G\S+\s+//; s/\s+$//;
      push(@{$listes_PTI{$nom_liste}},split(/\s+/,$_));
    }
    elsif(/^\s*noeuds/i or /^\s*elements/i or /^\s*[NAFE]/) {
      $is_liste_en_cours = 0;
    }
    elsif($is_liste_en_cours and /^\s*\d+(\s+\d+)*\s*$/i) {
      s/^\s+//; s/\s+$//;
      push(@{$listes_PTI{$nom_liste}},split(/\s+/,$_));
    }
  }
  close(Flis);

  }#if(-e $flis)

  #AFFICHAGE DES LISTES DE NOEUDS
  #foreach my $nom (keys(%listes_NOEUDS)) {
  #  print "$nom : @{$listes_NOEUDS{$nom}}\n";
  #}
  #AFFICHAGE DES LISTES D ARETES
  #foreach my $nom (keys(%listes_ARETES)) {
  #  print "$nom : @{$listes_ARETES{$nom}}\n";
  #}
  #AFFICHAGE DES LISTES DE FACES
  #foreach my $nom (keys(%listes_FACES)) {
  #  print "$nom : @{$listes_FACES{$nom}}\n";
  #}
  #AFFICHAGE DES LISTES D ELEMENTS
  #foreach my $nom (keys(%listes_ELEMENTS)) {
  #  print "$nom : @{$listes_ELEMENTS{$nom}}\n";
  #}
  #AFFICHAGE DES LISTES DE POINTS D INTEGRATION
  #foreach my $nom (keys(%listes_PTI)) {
  #  print "$nom : @{$listes_PTI{$nom}}\n";
  #}

  return($nom_maillage, $nb_noeuds, \@tab_noeuds, $nb_elts, \%tab_elements,
         \%listes_NOEUDS, \%listes_ARETES,
         \%listes_FACES, \%listes_ELEMENTS, \%listes_PTI);
}#sub lecture_mail_her
